/*
 * Compilación: $ make
 * Ejecución:   $ ./programa
 */
#include <list>
#include <iostream>
#include "Proteina.h"
#include "Cadena.h"
#include "Aminoacido.h"
#include "Atomo.h"
#include "Coordenada.h"

void print_proteina (Proteina p) {
    cout << endl;
    
    cout << "ID: " << p.get_id() << " Nombre: " << p.get_nombre() << endl;
    
    for (Cadena c: p.get_cadenas()) {
        cout << "Cadena: " << c.get_letra() << endl;
        
        for (Aminoacido a: c.get_aminoacidos()) {
            cout << "\tAminoacido: " << a.get_nombre() << ":" << a.get_numero() << endl;
            
            for (Atomo at: a.get_atomos()) {
                cout << "\t\tAtomo: " << at.get_nombre() << ":" << at.get_numero() << " [" << 
                at.get_coordenada().get_x() << ", " << at.get_coordenada().get_y() << ", " << 
                at.get_coordenada().get_z() << "]" << endl;
            }
        }
    }
}

/*
 */
int main (int argc, char **argv) {
    list<Proteina> proteinas;
    
    // instancia una proteina.
    Proteina p1 = Proteina("1rmd", "RAG1 DIMERIZATION DOMAIN");
    
    // la agrega a la lista.
    proteinas.push_back(p1);
    
    // instancia una cadena.
    Cadena a = Cadena("A");
    // instancia y agrega aminoacidos a la cadena.
    Aminoacido r = Aminoacido("CIS", 1);
    // instancia atomo.
    Atomo at = Atomo("CA", 1, 2.3, 3.3, 2.2);
    // agrega el átomo al aminoacido.
    r.add_atomo(at);
    // agrega otro átomo.
    r.add_atomo(Atomo("N", 2, 1.1, 2.1, 2.5));
    
    a.add_aminoacido(r);
    a.add_aminoacido(Aminoacido("ALA", 2));
    a.add_aminoacido(Aminoacido("HIS", 3));
    
    // agrega la cadena a la proteína.
    p1.add_cadena(a);
    
    // crea otra cadena.
    Cadena b = Cadena("B");
    // agrega aminoacidos a la cadena.
    b.add_aminoacido(Aminoacido("CYS", 5));
    b.add_aminoacido(Aminoacido("CYS", 15));
    b.add_aminoacido(Aminoacido("TYR", 3));
    
    // agrega otra cadena a la proteína.
    p1.add_cadena(b);
    
    print_proteina(p1);

    return 0;
}
